<?php
function sm_register_shortcode_handler_sm_google_map() {
	if ( defined( 'WPB_VC_VERSION' ) ) {
		class WPBakeryShortCode_sm_google_map extends WPBakeryShortCode {
			function content($atts, $content = null) {
				return sm_google_map_func( $atts, $content );
			}
		}
	} else {
		add_shortcode( 'sm_google_map', 'sm_google_map_func' );
	}
}

function sm_google_map_func( $atts, $content = '' ) {
	$view_params = array(
		'atts' => $atts,
		'content' => $content
	);
	return sm_render_view( 'google-map', $view_params );
}

sm_register_shortcode( array (
	'name' => esc_html__( 'Advanced Google Map', 'semona-extension' ),
	'base' => 'sm_google_map',
	'category' => esc_html__( 'by Theme-Paradise', 'semona-extension' ),
	'description' => esc_html__( 'Advanced Google Maps', 'semona-extension' ),
	'icon' => SM_PLUGIN_URL . '/assets/images/shortcodes/icon-google_map.png',
	'params' => array(
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'Map Type', 'semona-extension' ),
			'param_name' => 'type',
			'admin_label' => true,
			'value' => sm_get_map_type_array(),
			'description' => esc_html__( 'Select the type of google map to display', 'semona-extension' ),
		),
		array(
			'type' => 'attach_image',
			'heading' => esc_html__( 'Marker Icon', 'semona-extension' ),
			'param_name' => 'marker',
			'edit_field_class' => 'vc_col-sm-6 vc_column',
		),
		array(
			'type' => 'textfield',
			'heading' => esc_html__( 'Marker Anchor', 'semona-extension' ),
			'param_name' => 'marker_anchor',
			'description' => esc_html__( 'Specify anchor coordinates of custom global marker image in x, y pair. (ex. \'11, 15\').', 'polar-extension' ),
			'edit_field_class' => 'vc_col-sm-6 vc_column',
		),
		array(
			'type' => 'param_group',
			'heading' => esc_html__( 'Addresses', 'semona-extension' ),
			'param_name' => 'addresses',
			'value' => urlencode( json_encode( array(
				array(
					'address' => esc_html__( 'Address', 'semona-extension' ),
					'infobox_title' => esc_html__( 'Infobox Title', 'semona-extension' ),
					'infobox_content' => esc_html__( 'Enter infobox content here.', 'semona-extension' ),
				),
			) ) ),
			'params' => array(
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Address', 'semona-extension' ),
					'param_name' => 'address',
					'admin_label' => true,
				),
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Infobox Title', 'semona-extension' ),
					'param_name' => 'infobox_title',
				),
				array(
					'type' => 'textarea',
					'heading' => esc_html__( 'Infobox Content', 'semona-extension' ),
					'param_name' => 'infobox_content',
				),
				array(
					'type' => 'attach_image',
					'heading' => esc_html__( 'Location Photo', 'polar-extension' ),
					'param_name' => 'infobox_image',
					'description' => esc_html__( 'Location photo inside infobox.', 'polar-extension' ),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type' => 'attach_image',
					'heading' => esc_html__( 'Custom Marker Icon', 'semona-extension' ),
					'param_name' => 'marker',
					'description' => esc_html__( 'Location Specific custom marker icon.', 'semona-extension' ),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				),
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Custom Marker Anchor', 'semona-extension' ),
					'param_name' => 'marker_anchor',
					'description' => esc_html__( 'Specify location specific anchor coordinates of custom marker image in x, y pair. (ex. \'11, 15\').', 'polar-extension' ),
				),
			),
		),
		array(
			'type' => 'colorpicker',
			'heading' => esc_html__( 'Custom Overlay Color', 'semona-extension' ),
			'param_name' => 'overlay_color',
			'description' => esc_html__( 'Choose custom map overlay color to change the color scheme.', 'semona-extension' ),
		),
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'Infobox Styling', 'semona-extension' ),
			'param_name' => 'infobox_style',
			'value' => sm_get_map_infobox_styles_array(),
		),
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'Infobox Position', 'semona-extension' ),
			'param_name' => 'infobox_position',
			'value' => sm_get_map_infobox_positions_array(),
			'dependency' => array(
				'element' => 'infobox_style',
				'value' => 'custom'
			),
		),
		array(
			'type' => 'colorpicker',
			'heading' => esc_html__( 'Infobox Background Color', 'semona-extension' ),
			'param_name' => 'infobox_bg_color',
			'dependency' => array(
				'element' => 'infobox_style',
				'value' => 'custom'
			),
			'edit_field_class' => 'vc_col-sm-6 vc_column',
		),
		array(
			'type' => 'colorpicker',
			'heading' => esc_html__( 'Infobox Text Color', 'semona-extension' ),
			'param_name' => 'infobox_text_color',
			'dependency' => array(
				'element' => 'infobox_style',
				'value' => 'custom'
			),
			'edit_field_class' => 'vc_col-sm-6 vc_column',
		),
		array(
			'type' => 'textfield',
			'heading' => esc_html__( 'Height', 'semona-extension' ),
			'param_name' => 'height',
			'description' => esc_html__( 'Map height in pixel. Leave blank for responsive map.', 'semona-extension' ),
			'edit_field_class' => 'vc_col-sm-6 vc_column',
		),
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'Zoom Level', 'semona-extension' ),
			'param_name' => 'zoom',
			'value' => sm_get_map_zoom_levels_array(),
			'std' => '14',
			'description' => esc_html__( 'Higher number will be more zoomed in', 'semona-extension' ),
			'edit_field_class' => 'vc_col-sm-6 vc_column',
		),
		array(
			'type' => 'checkbox',
			'heading' => esc_html__( 'Allow Scrollwheel Zooming', 'semona-extension' ),
			'param_name' => 'scrollwheel',
			'value' => array( esc_html__( 'Yes', 'semona-extension' ) => 'yes' ),
			'description' => esc_html__( 'Enables zooming with mouse scroll.', 'semona-extension' ),
			'edit_field_class' => 'vc_col-sm-6 vc_column',
			'group' => esc_html__( 'Advanced Controls', 'semona-extension' ),
		),
		array(
			'type' => 'checkbox',
			'heading' => esc_html__( 'Show Scale Control', 'semona-extension' ),
			'param_name' => 'scale_ctrl',
			'value' => array( esc_html__( 'Yes', 'semona-extension' ) => 'yes' ),
			'std' => 'yes',
			'description' => esc_html__( 'Displays the map scale.', 'semona-extension' ),
			'edit_field_class' => 'vc_col-sm-6 vc_column',
			'group' => esc_html__( 'Advanced Controls', 'semona-extension' ),
		),
		array(
			'type' => 'checkbox',
			'heading' => esc_html__( 'Show Pan Control', 'semona-extension' ),
			'param_name' => 'zoom_pan_ctrl',
			'value' => array( esc_html__( 'Yes', 'semona-extension' ) => 'yes' ),
			'std' => 'yes',
			'description' => esc_html__( 'Displays pan control button.', 'semona-extension' ),
			'edit_field_class' => 'vc_col-sm-6 vc_column',
			'group' => esc_html__( 'Advanced Controls', 'semona-extension' ),
		),
		array(
			'type' => 'checkbox',
			'heading' => esc_html__( 'Show Infobox by default', 'semona-extension' ),
			'param_name' => 'popup',
			'value' => array( esc_html__( 'Yes', 'semona-extension' ) => 'yes' ),
			'std' => 'yes',
			'description' => esc_html__( 'Displays infobox by default when the map first loads.', 'semona-extension' ),
			'edit_field_class' => 'vc_col-sm-6 vc_column',
			'group' => esc_html__( 'Advanced Controls', 'semona-extension' ),
		),
		array(
			'type' => 'checkbox',
			'heading' => esc_html__( 'Address Pin Animation', 'semona-extension' ),
			'param_name' => 'pin_animation',
			'value' => array( esc_html__( 'Yes', 'semona-extension' ) => 'yes' ),
			'description' => esc_html__( 'Put checkmark to animate the address pins when the map first loads.', 'semona-extension' ),
			'group' => esc_html__( 'Advanced Controls', 'semona-extension' ),
		),
		sm_css_animation_class(),
		sm_css_animation_delay(),
		sm_extra_class()
	)
) );

add_action( 'wp_ajax_sm_cache_map', 'sm_cache_map' );
add_action( 'wp_ajax_nopriv_sm_cache_map', 'sm_cache_map' );

function sm_cache_map() {
	check_ajax_referer( 'sm_admin_ajax', 'security' );

	$addresses_to_cache = get_option( 'sm_map_addresses' );

	foreach ( $_POST['addresses'] as $address ) {

		if ( isset( $address['latitude'] ) && isset( $address['longitude'] ) ) {
			$addresses_to_cache[trim( $address['address'] )] = array(
				'address'   => trim( $address['address'] ),
				'latitude'  => $address['latitude'],
				'longitude' => $address['longitude']
			);

			if ( isset( $address['geocoded_address'] ) && $address['geocoded_address'] ) {
				$addresses_to_cache[trim( $address['address'] )]['address'] = $address['geocoded_address'];
			}
		}

	}

	update_option( 'sm_map_addresses', $addresses_to_cache );

	wp_die();

}